/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/****
 * \file: switch.c
 *
 * \brief:  source file for switch handling
 * \n       This file handle the switch status based on its pin status
 * \n       of respective switches.
 */
#include "stdio.h"
#include "dm8127_platform.h"
#include "switch.h"
#include "gpio.h"
#include "version.h"



#if 0
/**
 *\brief : GPIO bank 1's register pin handler.
 *
 *         This routine take the pin number and the status for the next
 *         action, i.e Enable or Disable.
 *
 *         This function initialize the GPIO bank 1.
 *
 *@param : gpio  [IN]  bit number for bank 1.
 *@param   value [IN]  current value to be modified.
 */


int set_gpio_bank1 (int gpio, int value)
{
	unsigned int regval;
	static int initialised = 0;

	if (!initialised) {
	/* Reset GPIO Subsystem */
		GPIO1_SYSCONFIG = 0x00000020; /* Software Reset */
		delay(0x90000);
		GPIO1_SYSCONFIG = 0x08; /* no-idle */
		initialised = 1;
	}

	/* Output Enable GPIO16 in Bank 1 */
	regval = 0;
	regval = GPIO0_OE;
	regval = regval & ~(1 << gpio);
	GPIO1_OE = regval;

	if (!value) {
		/* Set Low */
		regval = 0;
		regval = GPIO1_DATAOUT;
		regval = regval & ~(1 << gpio);
		GPIO1_DATAOUT = regval;
		regval = 0;
		regval = GPIO1_SETDATAOUT;
		regval = regval & ~(1 << gpio);
		GPIO1_SETDATAOUT = regval;
	} else {
		/* Set BT_ENABLE High */
		GPIO1_DATAOUT |= (1 <<  gpio);
		GPIO1_SETDATAOUT |= (1 << gpio);
	}

	return 0;
}

#endif
#if 0
void switch_pin_mux()
{
	/**
	 * DM8127 board having four switches connected via BtoB connector
	 *
	 * switch        connector pin        GPIO pin
	 *   1                70                 6
	 *   2                72                 13
	 *   3                75                 1
	 *   4                79                 15
	 */
#if 0
	WR_MEM_32(PINCNTL41, 0x000E0000);
	WR_MEM_32(PINCNTL42, 0x000E0000);
	WR_MEM_32(PINCNTL232, 0x00040001);
#endif

                                       /* Reset value */
	WR_MEM_32(PINCNTL69, 0x000E0080);    //0x000E0000
	WR_MEM_32(PINCNTL106, 0x000E0080);   //0x000E0000
	WR_MEM_32(PINCNTL107, 0x00040080);   // 0x00040000
	WR_MEM_32(PINCNTL109, 0x00060080);   // 0x00060000
}
#endif

/***
 * \brief: switch initialization function.
 *
 * \b \descr:  DM8127 board having four switches connected via BtoB connector
 *
 * \n       switch        connector pin        GPIO pin
 * \n         1                70                 6
 * \n         2                72                 13
 * \n         3                75                 1
 * \n         4                79                 15
 *
 * \param:  VOID
 * \return: SUCCESS
 */
UINT16 switch_init
(
	void
)
{


//	switch_pin_mux();

	/* Reset GPIO Subsystem */
	GPIO1_SYSCONFIG = 0x00000020; /* Software Reset */
	//DM388_wait(0x90000);
	GPIO1_SYSCONFIG = 0x100;      /* no-idle */
	GPIO1_OE = 0xFFFFFFFF;
	
	/* Reset GPIO Subsystem */
	GPIO2_SYSCONFIG = 0x00000020; /* Software Reset */
	//DM388_wait(0x90000);
	GPIO2_SYSCONFIG = 0x100; /* no-idle */
	GPIO2_OE = 0xFFFFFFFF;

    return 0;
}	

/****
 * \brief : Switch handler function
 */
STATUS switch_test
(
	void *testargs
)
{
	 Uart_stringSend("\r\n==================================="
					 "\r\n            Switch Test            "
					 "\r\n===================================\r\n");
	 Uart_stringSend("\r\nPress any push button switch on the DM8127 CSK and check"
			 	 	 "\r\nif the corresponding switch name is displayed on the console");
	switch_init();
#ifndef NDEBUG
//	while(1)
#endif
	{

		switch_get_press();
	}
	Uart_stringSend("\r\n-------------------------X-----------------------------");
	return 0;

}

/***
 * \brief: check Switch status
 *
 * \b \Descr: This function check the current status of the swtch.
 *
 * \param: VOID
 * \return: SUCCESS
 *
 */

UINT16 switch_get_press
(
	void
)
{
	UINT16 switch_num;
	UINT8 u8Option;

	u8Option = 'y';
#ifdef DEBUG
	printf("Press the switches SW5, SW6, SW7, SW8\n\n"
    		"terminate the program once finished the test\n");
#else
//	platform_write("\r\nPress the switches SW5, SW6, SW7, SW8\n\n"
//	    		   "terminate the program once finished the test\n\r");
#endif

#ifdef DEBUG
	while(TRUE)
#endif
	{



#ifndef PRE_COMPLIANCE
		while(TRUE)
		{
			while(TRUE)
			{
				if(((GPIO1_DATAIN) & (1 << SWITCH_3)) == 0)
				{
					switch_num = 5;
#ifdef DEBUG
					printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
					platform_write("\nSW%d is pressed\n",switch_num); // switch numbers
#endif
					break;
		     	}

				if(((GPIO1_DATAIN) & (1 << SWITCH_2)) == 0)
				{
					switch_num = 6;
#ifdef DEBUG
					printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
					platform_write("\nSW%d is pressed \n",switch_num); // switch numbers
#endif
					break;
				}

				if(((GPIO2_DATAIN) & (1 << SWITCH_1) ) == 0)
				{
					switch_num = 7;
#ifdef DEBUG
					printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
					platform_write("\nSW%d is pressed \n",switch_num); // switch numbers
#endif
					break;
				}

				if(((GPIO1_DATAIN) & (1 << SWITCH_4)) == 0)
				{
					switch_num = 8;
#ifdef DEBUG
					printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
					platform_write("\nSW%d is pressed \n",switch_num); // switch numbers
#endif
					break;
				}
			}
			Uart_stringSend("\r\nPress X/x for exiting the test"
							"\r\nPress Y/y to continue");

			uart_recv( Hanhler_uart0, &u8Option, uart_timeout );

			if ((u8Option >= 'A' ) && (u8Option <= 'Z') )
			{
				u8Option = u8Option + ' ';
			}

			if('x' == u8Option)
			{
				Uart_stringSend("\r\nx \r\nExiting from the push button test");
				Uart_stringSend("\r\n\n Push Button Test Completed!");
				break;
			}
			else if('y' == u8Option)
			{
				Uart_stringSend("\r\ny continue");
			}
	}
#else

		if(((GPIO1_DATAIN) & (1 << SWITCH_3)) == 0)
		{
			switch_num = 5;
#ifdef DEBUG
			printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
			platform_write("\nThe switch %d was pressed last\n",switch_num); // switch numbers
#endif

		}
		else
		{
			switch_num = 5;
			platform_write("\nSwitch %d is in ideal state\n",switch_num); // switch numbers
		}

		if(((GPIO1_DATAIN) & (1 << SWITCH_2)) == 0)
		{
			switch_num = 6;
#ifdef DEBUG
			printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
			platform_write("\nThe switch %d was pressed last\n",switch_num); // switch numbers
#endif

		}
		else
		{
			switch_num = 6;
			platform_write("\nSwitch %d is in ideal state\n",switch_num); // switch numbers
		}


    	if(((GPIO2_DATAIN) & (1 << SWITCH_1) ) == 0)
		{
			switch_num = 7;
#ifdef DEBUG
			printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
			platform_write("\nThe switch %d was pressed last\n",switch_num); // switch numbers
#endif
		}
		else
		{
			switch_num = 7;
			platform_write("\nSwitch %d is in ideal state\n",switch_num); // switch numbers
		}
    	if(((GPIO1_DATAIN) & (1 << SWITCH_4)) == 0)
		{
			switch_num = 8;
#ifdef DEBUG
			printf("\nThe switch %d was pressed last.",switch_num); // switch numbers
#else
			platform_write("\nThe switch %d was pressed last\n",switch_num); // switch numbers
#endif

		}
    	else
		{
    		switch_num = 8;
			platform_write("\nSwitch %d is in ideal state\n",switch_num); // switch numbers
		}
#endif
	}

return 0;
}
